﻿<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Skrócona lista pracowników etatowych</title>
		<script runat="server">

            //Wspólny kod dla pracownicy - ewidencja, lista skrócona i lista pełna    
            [DefaultWidth(20)]
            public enum Filtr {
                Wszyscy, Pracownicy, PracownicyMłodociani,
            }

            [DefaultWidth(20)]
            public enum Zakres {
                Wszyscy, Przyjęci, Zwolnieni,
            }

            public class PrnParams : Soneta.Business.ContextBase {

                public PrnParams(Context context)
                    : base(context) {
                }

                Filtr filtr = Filtr.Pracownicy;
                [Priority(1)]
                public Filtr Filtr {
                    get { return filtr; }
                    set {
                        filtr = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
                Zakres zakres;
                [Priority(2)]
                public Zakres Zakres {
                    get { return zakres; }
                    set {
                        zakres = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
                bool przedluzenia = true;
                [Priority(3)]
                [Caption("Uwzgl. przedłużenia")]
                public bool Przedluzenia {
                    get { return przedluzenia; }
                    set {
                        przedluzenia = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public bool Test(Pracownik idx, Date data, FromTo okres) {
                    bool bb = true;
                    if (Filtr != Filtr.Wszyscy || Zakres != Zakres.Wszyscy) {
                        PracHistoria historia = idx[data];
                        switch (Zakres) {
                            case Zakres.Przyjęci:
                                FromTo zatr1 = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                                bb &= okres.Contains(zatr1.From);
                                break;
                            case Zakres.Zwolnieni:
                                FromTo zatr2 = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                                bb &= okres.Contains(zatr2.To);
                                break;
                        }
                        switch (Filtr) {
                            case Filtr.Pracownicy:
                                bb &= !Młodociany(historia.Etat.RodzajZatrudnienia);
                                break;
                            case Filtr.PracownicyMłodociani:
                                bb &= Młodociany(historia.Etat.RodzajZatrudnienia);
                                break;
                        }
                    }
                    return bb;
                }

                static bool Młodociany(RodzajZatrudnienia rodzaj) {
                    switch (rodzaj) {
                        case RodzajZatrudnienia.Uczeń1Klasy:
                        case RodzajZatrudnienia.Uczeń2Klasy:
                        case RodzajZatrudnienia.Uczeń3Klasy:
                        case RodzajZatrudnienia.MłodocianyPrzyuczany:
                            return true;
                        default:
                            return false;
                    }
                }
            }

            PrnParams pars;
            [Soneta.Business.Context(Required = true)]
            public PrnParams Params {
                set { pars = value; }
            }

            public class SrParams : SerializableContextBase {
                public SrParams(Context context) : base(context) {
                }

                bool pelneStanowisko = false;
                [Priority(1)]
                [Caption("Stanowisko pełna nazwa")]
                public bool PelneStanowisko {
                    get { return pelneStanowisko; }
                    set {
                        pelneStanowisko = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            SrParams srpars;
            [SettingsContext]
            public SrParams SrPars {
                get { return srpars; }
                set { srpars = value; }
            }		
                       		    
            protected void dc_ContextLoad(object sender, EventArgs e) {
                OkresContext ok = (OkresContext)dc[typeof(OkresContext)];
                FromTo okres = ok.Okres;
                Date data = ok.Aktualny;

                ReportHeader1["OKRES"] = okres.ToString();

                switch (pars.Zakres) {
                    case Zakres.Przyjęci:
                        ReportHeader1["CO"] = "Przyjętych do pracy w okresie";
                        break;
                    case Zakres.Zwolnieni:
                        ReportHeader1["CO"] = "Zwolnionych z pracy w okresie";
                        break;
                    default:
                        ReportHeader1["CO"] = "Zatrudnionych w okresie";
                        break;
                }

                switch (pars.Filtr) {
                    case Filtr.Pracownicy:
                        ReportHeader1["KTO"] = "pracowników etatowych";
                        break;
                    case Filtr.PracownicyMłodociani:
                        ReportHeader1["KTO"] = "pracowników młodocianych";
                        break;
                    default:
                        ReportHeader1["KTO"] = "wszystkich pracowników";
                        break;
                }

                Row[] rows = (Row[])dc[typeof(Row[])];
                ArrayList result = new ArrayList();
                foreach (Pracownik idx in rows)
                    if (pars.Test(idx, data, okres))
                        result.Add(idx);
                Grid1.DataSource = result;
            }
		    
            void Grid1_BeforeRow(Object sender, RowEventArgs args) {
                PracHistoria ph = (PracHistoria)args.Row;

                col1.AddLine(ph.Nazwisko);
                if (ph.ImieDrugie != "")
                    col1.AddLine(ph.Imie + ", " + ph.ImieDrugie);
                else
                    col1.AddLine(ph.Imie);
                
                col2.AddLine(ph.Adres.Linia1);
                col2.AddLine(ph.Adres.Linia2);
                
                col3.AddLine(ph.Adres.Telefon);
                col3.AddLine(ph.PESEL);

                col4.AddLine(GetStanowisko(ph));
                col4.AddLine(ph.Etat.OkresZatrudnienia.From);
                col4.AddLine(ph.Etat.Wymiar);
            }

            string GetStanowisko(PracHistoria ph) {
                string stanowiskoPelne = "";
                if (srpars.PelneStanowisko)
                    stanowiskoPelne = ph.Etat.StanowiskoPełne;
                if (stanowiskoPelne.Length == 0)
                    stanowiskoPelne = ph.Etat.Stanowisko;
                return stanowiskoPelne;
            }            

</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="PracListaSkrócona" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" 
                TypeName="Soneta.Business.Row[], Soneta.Business" 
                oncontextload="dc_ContextLoad"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" runat="server" 
                title="Skrócona lista %KTO%|&lt;/strong&gt;%CO%: &lt;strong&gt;%OKRES%"></cc1:ReportHeader>
			<ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" VAlign="Top" DataMember="#" Caption="LP." ID="lp"></ea:GridColumn>
                    <ea:GridColumn Width="28" VAlign="Top" Caption="Nazwisko<br>Imiona" ID="col1" EncodeHTML="true"></ea:GridColumn>
                    <ea:GridColumn Width="34" VAlign="Top" Caption="Miejsce zamieszkania<br>Kod pocztowy, miasto" ID="col2" EncodeHTML="true"></ea:GridColumn>
                    <ea:GridColumn Width="15" VAlign="Top" Caption="Telefon<br>PESEL" ID="col3"></ea:GridColumn>
                    <ea:GridColumn ColSpan="2" Width="20" VAlign="Top" Caption="Stanowisko<br>Data zatr.<br>Etat" ID="col4" EncodeHTML="true"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
		</form>
	</body>
</HTML>

